<?php
/*
Plugin Name: AzuraCast Now Playing PRO 1.5.7
Version: 1.5.7
Description: Tyylikäs AzuraCast soitin WP:hen. V1.5.7: Muokattavan tekstin väri ja tausta toimivat oikein.
Author: Mika Ruohomäki | https://novoasema.net
*/

if (!defined('ABSPATH')) exit;

/* -------------------------
   DEFAULT OPTIONS
--------------------------*/
register_activation_hook(__FILE__, function () {
    add_option('ac_station_api', '');
    add_option('ac_stream_url', '');
    add_option('ac_autoplay', '1');
    add_option('ac_player_text', '');
    add_option('ac_text_color', '#ffffff');
    add_option('ac_text_bg', '#000000');
    add_option('ac_text_opacity', '0.85');
});

/* -------------------------
   ADMIN MENU
--------------------------*/
add_action('admin_menu', function () {
    add_options_page(
        'AzuraCast Player',
        'AzuraCast Player',
        'manage_options',
        'azuracast-player',
        'ac_settings_page'
    );
});

/* -------------------------
   REGISTER SETTINGS
--------------------------*/
add_action('admin_init', function () {
    $settings = [
        'ac_station_api',
        'ac_stream_url',
        'ac_autoplay',
        'ac_player_text',
        'ac_text_color',
        'ac_text_bg',
        'ac_text_opacity'
    ];
    foreach ($settings as $s) register_setting('ac_settings', $s);
});

/* -------------------------
   SETTINGS PAGE
--------------------------*/
function ac_settings_page() { ?>
<div class="wrap">
    <h1>AzuraCast Now Playing PRO 1.5.7 </h1>
    <div style="background:#fff;border:1px solid #ccd0d4;padding:15px;margin-bottom:20px;">
        <strong>Shortcode:</strong><br>
        <code style="font-size:15px;padding:6px 10px;display:inline-block;">
            [azuracast_player]
        </code>
    </div>

    <form method="post" action="options.php">
        <?php settings_fields('ac_settings'); ?>
        <table class="form-table">
            <tr>
                <th>Station API URL</th>
                <td><input type="text" name="ac_station_api" class="regular-text"
                    value="<?php echo esc_attr(get_option('ac_station_api')); ?>"></td>
            </tr>

            <tr>
                <th>Stream URL</th>
                <td><input type="text" name="ac_stream_url" class="regular-text"
                    value="<?php echo esc_attr(get_option('ac_stream_url')); ?>"></td>
            </tr>

            <tr>
                <th>Autoplay</th>
                <td>
                    <label>
                        <input type="checkbox" name="ac_autoplay" value="1"
                            <?php checked(get_option('ac_autoplay'), '1'); ?>>
                        Käynnistä soitto automaattisesti (muted)
                    </label>
                </td>
            </tr>

            <tr>
                <th>Soittimen teksti</th>
                <td>
                    <textarea name="ac_player_text" rows="4" class="large-text"><?php
                        echo esc_textarea(get_option('ac_player_text'));
                    ?></textarea>
                </td>
            </tr>

            <tr>
                <th>Tekstin väri</th>
                <td>
                    <input type="color" name="ac_text_color" value="<?php echo esc_attr(get_option('ac_text_color', '#ffffff')); ?>">
                </td>
            </tr>

            <tr>
                <th>Taustaväri</th>
                <td>
                    <input type="color" name="ac_text_bg" value="<?php echo esc_attr(get_option('ac_text_bg', '#000000')); ?>">
                </td>
            </tr>

            <tr>
                <th>Läpinäkyvyys</th>
                <td>
                    <input type="number" name="ac_text_opacity" value="<?php echo esc_attr(get_option('ac_text_opacity', '0.85')); ?>" min="0" max="1" step="0.05">
                </td>
            </tr>

        </table>

        <?php submit_button(); ?>
    </form>
</div>
<?php }

/* -------------------------
   SHORTCODE
--------------------------*/
add_shortcode('azuracast_player', function () {

    $api   = get_option('ac_station_api');
    $stream = get_option('ac_stream_url');

    if (!$api || !$stream) {
        return '<p><strong>AzuraCast Player:</strong> Asetukset puuttuvat.</p>';
    }

    wp_enqueue_style('ac-style', plugin_dir_url(__FILE__) . 'assets/style.css');
    wp_enqueue_script('ac-js', plugin_dir_url(__FILE__) . 'assets/player.js', [], null, true);

    wp_localize_script('ac-js', 'ACDATA', [
        'api'      => esc_url($api),
        'stream'   => esc_url($stream),
        'autoplay' => get_option('ac_autoplay') === '1'
    ]);

    $text_color   = get_option('ac_text_color', '#ffffff');
    $text_bg      = get_option('ac_text_bg', '#000000');
    $text_opacity = get_option('ac_text_opacity', '0.85');
    $player_text  = get_option('ac_player_text');

    ob_start(); ?>

<div class="ac-player glass">
    <audio id="ac-audio" preload="auto"
        <?php if (get_option('ac_autoplay') === '1') echo 'muted autoplay'; ?>></audio>

    <div class="ac-info">
        <div class="ac-song-wrapper">
            <div class="ac-song" id="ac-song">Yhdistetään…</div>
            <?php if ($player_text): ?>
                <div class="ac-player-text" id="ac-player-text"
                     style="color: <?php echo esc_attr($text_color); ?>;
                            background: <?php echo esc_attr($text_bg); ?>;
                            opacity: <?php echo esc_attr($text_opacity); ?>;">
                    <?php echo wp_kses_post(nl2br($player_text)); ?>
                </div>
            <?php endif; ?>
        </div>

        <div class="ac-meta">
            <span id="ac-dj"></span>
            <span id="ac-listeners"></span>
        </div>
    </div>

    <div class="ac-volume">
        🔊
        <input type="range" id="ac-volume" min="0" max="1" step="0.01" value="0.8">
    </div>

    <button id="ac-play">▶ Kuuntele</button>
</div>

<?php return ob_get_clean();
});
